jQuery(document).ready(function(jQuery) {
    
    var grad_input = jQuery(".smile-gradient-colorpicker");
    jQuery.each( grad_input, function( index,obj ){
        var $this       = jQuery(this),
            input       = jQuery(this).attr("id"),
            css_preview = $this.attr('data-css-preview') || '',
            selector    = $this.attr('data-css-selector') || '',
            property    = $this.attr('data-css-property') || '',
            type_of     = $this.attr('data-style-for') || '',
            value       = $this.val(),
            unit        = $this.attr('data-unit') || 'px',
            input_val   = jQuery("#"+input),
            old_grad    = '',
            old_bg      = '';
            
            if( type_of == 'smile-info_bar-designer' ){
                old_grad =  jQuery('#smile_bg_gradient_lighten', window.parent.document ).val(),
                old_bg   =  jQuery('#smile_bg_color', window.parent.document ).val();
            }else if( type_of == 'smile-slide_in-designer' ){
                old_grad =  jQuery('#smile_slidein_bg_gradient_lighten', window.parent.document ).val(),
                old_bg   =  jQuery('#smile_slidein_bg_color', window.parent.document ).val();
            }
      
       if(old_grad !== ''){
        var val_arr      = value.split("|"),
            first_color  = old_grad,
            sec_color    = old_bg,
            first_deg    = val_arr[2],
            sec_deg      = val_arr[3],
            grad_type    = val_arr[4],
            direction    = val_arr[5],
            grad_val     = first_color+'|'+sec_color+'|'+first_deg+'|'+sec_deg+'|'+grad_type+'|'+direction;
            value        = grad_val;
            $this.attr('data-first-color',first_color)
            $this.attr('data-sec-color',sec_color);
            jQuery('#smile_bg_gradient_lighten').remove();
            jQuery('#smile_bg_gradient_lighten', window.parent.document ).val('');
            jQuery('#smile_slidein_bg_gradient_lighten', window.parent.document ).val('');
            jQuery('#smile_slidein_bg_gradient_lighten').remove();
            $this.val(value);
       }

        partial_grad_css( css_preview, selector, property, value, unit );

        jQuery(document).on('smile-colorpicker-change', function( e, el, val) {
           // console.log(jQuery(el));
            if( jQuery(el).hasClass('smile-gradient-colorpicker_one') || jQuery(el).hasClass('smile-gradient-colorpicker_sec')  ){
                var first_color = sec_color =  first_deg = sec_deg = '';  
             /*   var grd_main      = input_val ;
                console.log(jQuery(el));
               console.log(input);*/
                var element       = jQuery(el).data("element"),               
                    grd_main       = jQuery("."+element),
                    all_val       = grd_main.val(),
                    first_color   = grd_main.attr('data-first-color') || '',
                    sec_color     = grd_main.attr('data-sec-color') || '',
                    first_deg     = grd_main.attr('data-first-deg') || '',
                    sec_deg       = grd_main.attr('data-sec-deg') || '',
                    grad_type     = grd_main.attr('data-grad-type') || '',
                    grd_direction = grd_main.attr('data-grad-direction') || '',
                    new_val       = '';
                    
                if( jQuery(el).hasClass('smile-gradient-colorpicker_one')  ){
                    new_val = val+'|'+sec_color+'|'+first_deg+'|'+sec_deg+'|'+grad_type+'|'+grd_direction;
                    grd_main.val(new_val);
                    grd_main.attr('data-first-color','');
                    grd_main.attr('data-first-color',val);
                }

                if( jQuery(el).hasClass('smile-gradient-colorpicker_sec')  ){
                    new_val = first_color+'|'+val+'|'+first_deg+'|'+sec_deg+'|'+grad_type+'|'+grd_direction;
                    grd_main.val(new_val);
                    grd_main.attr('data-sec-color','');
                    grd_main.attr('data-sec-color',val);
                }    
                jQuery(document).trigger('cp-grad-change', [el, val] );  
            }   
        });

        jQuery(document).on('cp-slider-slide', function( e, el, val) {
            var element = jQuery(el).data("element");            
           if( jQuery(el).hasClass(element+'_end') || jQuery(el).hasClass(element+'_start') ) {
                var first_color   = sec_color =  first_deg = sec_deg = '';  
                
                var element       = jQuery(el).data("element"),               
                    grd_main      = jQuery("."+element);
                    //console.log(grd_main);
                var all_val       = grd_main.val(),
                    first_color   = grd_main.attr('data-first-color') || '',
                    sec_color     = grd_main.attr('data-sec-color') || '',
                    first_deg     = grd_main.attr('data-first-deg') || '',
                    sec_deg       = grd_main.attr('data-sec-deg') || '',
                    grad_type     = grd_main.attr('data-grad-type') || '',
                    grd_direction = grd_main.attr('data-grad-direction') || '',
                    new_val       = '';
                
                if( jQuery(el).hasClass(element+'_start') ) {
                    new_val = first_color+'|'+sec_color+'|'+val+'|'+sec_deg+'|'+grad_type+'|'+grd_direction;
                    grd_main.val(new_val);
                    grd_main.attr('data-first-deg','');
                    grd_main.attr('data-first-deg',val);
                }
                if( jQuery(el).hasClass(element+'_end') ) {
                    new_val = first_color+'|'+sec_color+'|'+first_deg+'|'+val+'|'+grad_type+'|'+grd_direction;
                    grd_main.val(new_val);
                    grd_main.attr('data-sec-deg','');
                    grd_main.attr('data-sec-deg',val);
                }  
                jQuery(document).trigger('cp-grad-change', [el, val] );   
            }  
        });

        jQuery(document).on('smile-select-dropdown-change', function( e, el, val) {
           
            if( jQuery(el).hasClass('cp-gradient-type') || jQuery(el).hasClass('cp-gradient-direction') ) {
                
                var first_color   = sec_color =  first_deg = sec_deg = '';  
                var element       = jQuery(el).data("element"),               
                    grd_main      = jQuery("."+element),
                    all_val       = grd_main.val(),
                    first_color   = grd_main.attr('data-first-color') || '',
                    sec_color     = grd_main.attr('data-sec-color') || '',
                    first_deg     = grd_main.attr('data-first-deg') || '',
                    sec_deg       = grd_main.attr('data-sec-deg') || '',
                    grad_type     = grd_main.attr('data-grad-type') || '',
                    grd_direction = grd_main.attr('data-grad-direction') || '',
                    new_val       = '';
                    
                    if( jQuery(el).hasClass('cp-gradient-type') ) {
                        new_val = first_color+'|'+sec_color+'|'+first_deg+'|'+sec_deg+'|'+val+'|'+grd_direction;
                        grd_main.val(new_val);
                        grd_main.attr('data-sgrad-type','');
                        grd_main.attr('data-grad-type',val);
                    }

                    if( jQuery(el).hasClass('cp-gradient-direction') ) {
                        new_val = first_color+'|'+sec_color+'|'+first_deg+'|'+sec_deg+'|'+grad_type+'|'+val;
                        grd_main.val(new_val);
                        grd_main.attr('data-grad-direction','');
                        grd_main.attr('data-grad-direction',val);
                    }

                    jQuery(document).trigger('cp-grad-change', [el, val] ); 
            }
        });

        jQuery(document).on('cp-grad-change', function( e, el, val) {
            var element     = jQuery(el).data("element");
            var $this       = jQuery("."+element);
            var css_preview = $this.attr('data-css-preview') || '';
            var selector    = $this.attr('data-css-selector') || '';
            var property    = $this.attr('data-css-property') || '';
            var value       = $this.val();
            var unit        = $this.attr('data-unit') || 'px';
            jQuery(document).trigger('cp-grad-color-change', [el, value] ); 
            partial_grad_css( css_preview, selector, property, value, unit );
        });
         // apply css by - inline
        function partial_grad_css( css_preview, selector, property, value, unit ) {       

            if( css_preview != 1 || null == css_preview || 'undefined' == css_preview ) {
                var apply_to = jQuery("#smile_design_iframe").contents().find(selector);
                         
                var val_arr  = value.split("|"),
                 first_color = val_arr[0],
                 sec_color   = val_arr[1],
                 first_deg   = val_arr[2],
                 sec_deg     = val_arr[3],
                 grad_type   = val_arr[4];
                 direction   = val_arr[5],
                 grad_name   = '';

                switch(direction){
                    case 'center_left':
                        grad_name = 'left';
                        break;
                    case 'center_Right':                   
                        grad_name = 'right';
                        break;

                    case 'top_center':
                        grad_name = 'top';
                        break;

                    case 'top_left':
                        grad_name = 'top left';
                        break;

                    case 'top_right':
                        grad_name = 'top right';
                        break;

                    case 'bottom_center':
                        grad_name = 'bottom';
                        break;

                    case 'bottom_left':
                        grad_name = 'bottom left';
                        break;

                    case 'bottom_right':
                        grad_name = 'bottom right';
                        break;

                    case 'center_center':
                        grad_name = 'center';
                         if( grad_type == 'linear'){
                           grad_name = 'top left';
                         }
                       
                        break;
                }
                
                if( grad_type == 'linear'){
                    var ie_css  = grad_type+'-gradient(to '+grad_name+', '+first_color+' '+first_deg +'%, '+sec_color+' '+sec_deg +'%)',
                        web_css = '-webkit-'+grad_type+'-gradient('+grad_name+', '+first_color+' '+first_deg +'%, '+sec_color+' '+sec_deg +'%)',
                        o_css   = '-o-'+grad_type+'-gradient('+grad_name+', '+first_color+' '+first_deg +'%, '+sec_color+' '+sec_deg +'%)',
                        mz_css  = '-moz-'+grad_type+'-gradient('+grad_name+', '+first_color+' '+first_deg +'%, '+sec_color+' '+sec_deg +'%)';
                }else{
                    var ie_css  = grad_type+'-gradient( ellipse farthest-corner at '+grad_name+', '+first_color+' '+first_deg +'%, '+sec_color+' '+sec_deg +'%)',
                        web_css = '-webkit-'+grad_type+'-gradient( ellipse farthest-corner at '+grad_name+', '+first_color+' '+first_deg +'%, '+sec_color+' '+sec_deg +'%)',
                        o_css   = '-o-'+grad_type+'-gradient( ellipse farthest-corner at '+grad_name+', '+first_color+' '+first_deg +'%, '+sec_color+' '+sec_deg +'%)',
                        mz_css  = '-moz-'+grad_type+'-gradient( ellipse farthest-corner at '+grad_name+', '+first_color+' '+first_deg +'%, '+sec_color+' '+sec_deg +'%)';
                }

                apply_to.css({
                    'background' : web_css,
                    'background' : o_css,
                    'background' : mz_css,
                    'background' : ie_css
                });
               
                jQuery(document).trigger('updated', [css_preview, selector, property, value, unit]);
            }
        }

    });

});