<?php
/**
* Plugin Name: Connects - Infusionsoft Addon
* Plugin URI: 
* Description: Use this plugin to integrate Infusionsoft with Connects.
* Version: 2.2.2
* Author: Brainstorm Force
* Author URI: https://www.brainstormforce.com/
* License: http://themeforest.net/licenses
*/

if(!class_exists('Smile_Mailer_Infusionsoft')){
	class Smile_Mailer_Infusionsoft{

    private $slug;
    private $setting;

		function __construct(){
			require_once( 'infusionsoft/isdk.php' );
			add_action( 'wp_ajax_get_infusionsoft_data', array($this,'get_infusionsoft_data' ));
			add_action( 'wp_ajax_update_infusionsoft_authentication', array($this,'update_infusionsoft_authentication' ));
			add_action( 'wp_ajax_disconnect_infusionsoft', array($this,'disconnect_infusionsoft' ));
			add_action( 'wp_ajax_infusionsoft_add_subscriber', array($this,'infusionsoft_add_subscriber' ));
			add_action( 'wp_ajax_nopriv_infusionsoft_add_subscriber', array($this,'infusionsoft_add_subscriber' ));
			add_action( 'admin_init', array( $this, 'enqueue_scripts' ) );
			add_action( 'init', array( $this, 'enqueue_scripts' ) );
			$this->setting  = array(
				'name' => 'Infusionsoft',
				'class_name' => 'Smile_Mailer_Infusionsoft',
				'parameters' => array( 'app', 'api_key' ),
				'where_to_find_url' => 'http://help.infusionsoft.com/userguides/get-started/tips-and-tricks/api-key',
				'mailer_type' => 'multiple',
				'logo_url' => plugins_url('images/logo.png', __FILE__)
			);
			$this->slug = 'infusionsoft';
		}

		/*
		 * Function Name: enqueue_scripts
		 * Function Description: Add custon scripts
		 */
		
		function enqueue_scripts() {
			if( function_exists( 'cp_register_addon' ) ) {
				cp_register_addon( $this->slug, $this->setting );
			}
			wp_register_script( $this->slug.'-script', plugins_url('js/'.$this->slug.'-script.js', __FILE__), array('jquery'), '1.1', true );
			wp_enqueue_script( $this->slug.'-script' );
			wp_register_style( $this->slug.'-style', plugins_url('css/'.$this->slug.'-style.css', __FILE__) );
			wp_enqueue_style( $this->slug.'-style' );
			add_action( 'admin_head', array( $this, 'hook_css' ) );
		}


		/*
		 * Function Name: hook_css
		 * Function Description: Adds background style script for mailer logo.
		 */


		function hook_css() {
			if( isset( $this->setting['logo_url'] ) ) {
				if( $this->setting['logo_url'] != '' ) {
					$style = '<style>table.bsf-connect-optins td.column-provider.'.$this->slug.'::after {background-image: url("'.$this->setting['logo_url'].'");}.bend-heading-section.bsf-connect-list-header .bend-head-logo.'.$this->slug.'::before {background-image: url("'.$this->setting['logo_url'].'");}</style>';
					echo $style;
				}
			}
		}


		/*
		 * Function Name: get_infusionsoft_data
		 * Function Description: Get Infusionsoft input fields
		 */
		 
		function get_infusionsoft_data() {

			if ( ! current_user_can( 'access_cp' ) ) {
				die(-1);
			}
			$isKeyChanged = false;

			$connected = false;
			ob_start();

			$infusionsoft_api = get_option($this->slug.'_api_key');
			$infusionsoft_app = get_option($this->slug.'_app');

            if( $infusionsoft_api != '' ) {
            	try {
					$myApp = new CP_iSDK;
					$res = $myApp->cfgCon( $infusionsoft_app, $infusionsoft_api, "on" );
					$campaigns = $myApp->getWebFormMap();
					$formstyle = 'style="display:none;"';
				} catch( CP_iSDKException $ex ) {
					$formstyle = '';
					$isKeyChanged = true;    
				}	            	
            } else {
            	$formstyle = '';
            }
            ?>
			<div class="bsf-cnlist-form-row" <?php echo $formstyle; ?>>
				<label for="cp-list-name" ><?php _e( $this->setting['name'] . " API Key", "smile" ); ?></label>
            	<input type="text" autocomplete="off" id="<?php echo $this->slug; ?>_api_key" name="<?php echo $this->slug; ?>_api_key" value="<?php echo esc_attr( $infusionsoft_api ); ?>"/>
	        </div>

	        <div class="bsf-cnlist-form-row" <?php echo $formstyle; ?>>
				<label for="cp-list-name" ><?php _e( $this->setting['name'] . " App Name", "smile" ); ?></label>
            	<input type="text" autocomplete="off" id="<?php echo $this->slug; ?>_app" name="<?php echo $this->slug; ?>_app" value="<?php echo esc_attr( $infusionsoft_app ); ?>"/>
	        </div>

            <div class="bsf-cnlist-form-row <?php echo $this->slug; ?>-list">
	            <?php
	            if( $infusionsoft_api != '' && !$isKeyChanged ) {
		            $infusionsoft_lists = $this->get_infusionsoft_lists( $infusionsoft_api, $infusionsoft_app );

					if( !empty( $infusionsoft_lists ) ){
						$connected = true;
					?>
					<label for="<?php echo $this->slug; ?>-list"><?php echo __( "Select Lists", "smile" ); ?></label>
					<select id="<?php echo $this->slug; ?>-list" class="bsf-cnlist-select select2-<?php echo $this->slug; ?>-list" name="<?php echo $this->slug; ?>-list" multiple>
					<?php
						foreach($infusionsoft_lists as $id => $name) {
					?>
						<option value="<?php echo $id; ?>"><?php echo $name; ?></option>
					<?php
						}
					?>
					</select>
					<?php
					} else {
					?>
						<label for="<?php echo $this->slug; ?>-list"><?php echo __( "You need at least one list added in " . $this->setting['name'] . " before proceeding.", "smile" ); ?></label>
					<?php
					}
				} 	
	            ?>
            </div>

            <div class="bsf-cnlist-form-row <?php echo $this->slug; ?>-action_id">
            <?php
            if( !empty( $infusionsoft_lists ) ){
            ?>
				<label for="cp-list-name" ><?php _e( "Action ID", "smile" ); ?></label>
            	<input type="text" autocomplete="off" id="<?php echo $this->slug; ?>_action_id" name="<?php echo $this->slug; ?>_action_id" value="" placeholder="(Optional)"/>
            	<div class="bsf-cnlist-form-row">
            		<div class="bsf-cnlist-mailer-help ">
            			<a target="_blank" href="http://evergreenbusinesssystem.com/webinarfiles/infusionsoft_integration_manual.pdf">Where is Action ID?</a>
            		</div>
            	</div>
            <?php
            }
            ?>
	        </div>

            <div class="bsf-cnlist-form-row">
            	<?php if( $infusionsoft_api == "" ) { ?>
	            	<button id="auth-<?php echo $this->slug; ?>" class="button button-secondary auth-button" disabled><?php _e( "Authenticate " . $this->setting['name'], "smile" ); ?></button><span class="spinner" style="float: none;"></span>
	            <?php } else {
	            		if( $isKeyChanged ) {
	            ?>
	            	<div id="update-<?php echo $this->slug; ?>" class="update-mailer" data-mailerslug="<?php echo $this->setting['name']; ?>" data-mailer="<?php echo $this->slug; ?>"><span><?php _e( "Your credentials seems to be changed.</br>Use different '" . $this->setting['name'] . "' credentials?", "smile" ); ?></span></div><span class="spinner" style="float: none;"></span>
	            <?php
	            		} else {
	            ?>
	            	<div id="disconnect-<?php echo $this->slug; ?>" class="button button-secondary" data-mailerslug="<?php echo $this->setting['name']; ?>" data-mailer="<?php echo $this->slug; ?>"><span><?php _e( "Use different '" . $this->setting['name'] . "' account?", "smile" ); ?></span></div><span class="spinner" style="float: none;"></span>
	            <?php
	            		}
	            ?>
	            <?php } ?>
	        </div>

            <?php
            $content = ob_get_clean();

            $result['data'] = $content;
            $result['helplink'] = $this->setting['where_to_find_url'];
            $result['isconnected'] = $connected;
            echo json_encode($result);
            exit();
        }

		
		/*
		 * Function Name: infusionsoft_add_subscriber
		 * Function Description: Add subscriber
		 */
		
		function infusionsoft_add_subscriber() {
			$ret = true;
			$email_status = false;
			$detailed_msg = '';

			$style_id = isset( $_POST['style_id'] ) ? esc_attr( $_POST['style_id'] ) : '';
			if( $style_id !== '' ){
                check_ajax_referer( 'cp-submit-form-'.$style_id );
            }
			$contact = array_map( 'sanitize_text_field', wp_unslash( $_POST['param'] ) );

			$contact['source'] = ( isset( $_POST['source'] ) ) ? esc_attr( $_POST['source'] ) : '';

			$msg = isset( $_POST['message'] ) ? $_POST['message'] : __( 'Thanks for subscribing. Please check your mail and confirm the subscription.', 'smile' );
			
			$email =( isset( $_POST['param']['email'] ) ) ? sanitize_email( esc_attr( $_POST['param']['email'] ) ): ''; 

			//	Check Email in MX records
			if( isset( $email ) ) {
				$email_status = ( !( isset( $_POST['only_conversion'] ) ? true : false ) ) ? apply_filters('cp_valid_mx_email', $email ) : false;
			}

			$debug_data = get_option( 'convert_plug_debug' );
            $sub_def_action = isset( $debug_data['cp-post-sub-action'] ) ? $debug_data['cp-post-sub-action'] : 'process_success';
            $smile_lists = get_option('smile_lists');
			$infusionsoft_api = get_option( $this->slug . '_api_key' );
			$infusionsoft_app = get_option( $this->slug . '_app' );
			$infusionsoft_list_ids = explode( "," , $_POST['list_id'] );
			$infusionsoft_action_id = $smile_lists[$_POST['list_parent_index']]['infusionsoft_action_id'];

			if ( is_user_logged_in() && current_user_can( 'access_cp' ) ) {
                $default_error_msg = __( 'THERE APPEARS TO BE AN ERROR WITH THE CONFIGURATION.', 'smile' );
            } else {
                $default_error_msg = __( 'THERE WAS AN ISSUE WITH YOUR REQUEST. Administrator has been notified already!', 'smile' );
            }

			if( $email_status ) {
				if( function_exists( "cp_add_subscriber_contact" ) ){
					$option = isset( $_POST['option'] ) ? $_POST['option'] : '';
					$isuserupdated = cp_add_subscriber_contact( $option, $contact );
				}
				if ( !$isuserupdated ) {  // if user is updated dont count as a conversion
					// update conversions 
					smile_update_conversions($style_id);
				}
				if( isset( $email ) ) {
					$status = 'success';

					$myApp = new CP_iSDK;
	      			$myApp->cfgCon( $infusionsoft_app, $infusionsoft_api, "on" );

	      			$contact_details = array(
						'Email'     => $email,
					);

					foreach( $_POST['param'] as $key => $p ) {
                        if( $key != 'email' && $key != 'user_id' && $key != 'date' ){
                        	$contact_details[$key] = $p;
                        }
                    }
					$response = array();
					try {

						$returnFields = array('Id');
						$exist = $myApp->findByEmail( $email, $returnFields );
						
						if ( !empty($exist) && $sub_def_action != 'process_success' ) {	
							$optinvar =	get_option( 'convert_plug_settings' );	
							$msg = ( $optinvar['cp-default-messages'] ) ? isset( $optinvar['cp-already-subscribed']) ? stripslashes( $optinvar['cp-already-subscribed'] ) : __( 'Already Subscribed!', 'smile' ) : __( 'Already Subscribed!', 'smile' );

							print_r(json_encode(array(
								'action' => ( isset( $_POST['message'] ) ) ? 'message' : 'redirect',
								'email_status' => $email_status,
								'status' => 'error',
								'message' => $msg,
								'url' => ( isset( $_POST['message'] ) ) ? 'none' : esc_url( $_POST['redirect'] ),
								'detailed_msg' => $detailed_msg
							)));
							exit();
						}

						$new_contact_id = $myApp->addWithDupCheck( $contact_details, $checkType = 'Email' );						

						if( is_int( $new_contact_id ) ) {

							//$myApp->optIn( $contact_details['Email'] );
							foreach ($contact_details as $key => $value) {
							    $pos = strpos(strtolower($key), 'email');
							    if ( $pos !== false) {
							        $myApp->optIn( $contact_details[$key] );
							    }
							}

							if( count( $infusionsoft_list_ids ) > 0 ) {
								foreach( $infusionsoft_list_ids as $infusionsoft_list_id ) {
									if( $infusionsoft_list_id != -1 ) {
										$v = $myApp->grpAssign( $new_contact_id, $infusionsoft_list_id );
										if(  !$v ) {
											$response[] = $infusionsoft_list_id;
										}
									}
								}
							}
							$action_run_as = ( $infusionsoft_action_id != '' ) ? $myApp->runAS( $new_contact_id, $infusionsoft_action_id ) : '';
						} else {
							$error = $new_contact_id;
							throw new CP_iSDKException($error);
						}

					} catch ( CP_iSDKException $ex ) {

						if ( is_user_logged_in() && current_user_can( 'access_cp' ) ) {
							$detailed_msg = $ex->getMessage();
			            } else {
			                $detailed_msg = '';
			            }

			            if( $detailed_msg !== '' & $detailed_msg !== null ) {
			                $page_url = isset( $_POST['cp-page-url'] ) ? esc_url( $_POST['cp-page-url'] ) : '';

			                // notify error message to admin
			                if( function_exists('cp_notify_error_to_admin') ) {
			                    $result   = cp_notify_error_to_admin($page_url);
			                }
			            }

						if( isset( $_POST['source'] ) ) {
			        		return false;
			        	} else {
			        		print_r(json_encode(array(
								'action' => ( isset( $_POST['message'] ) ) ? 'message' : 'redirect',
								'email_status' => $email_status,
								'status' => 'error',
								'message' => $default_error_msg,
								'url' => ( isset( $_POST['message'] ) ) ? 'none' : esc_url( $_POST['redirect'] ),
								'detailed_msg' => $detailed_msg
							)));
							exit();
			        	}
					}
			        if( !empty( $response ) ) {
			        	//	Show message for already subscribed users
			        	/*if( !empty($exist) ){
							$response[]
						}*/
						$optinvar =	get_option( 'convert_plug_settings' );	
						if ( $sub_def_action != 'process_success' ) {			
						    $msg = ( $optinvar['cp-default-messages'] ) ? isset( $optinvar['cp-already-subscribed']) ? stripslashes( $optinvar['cp-already-subscribed'] ) : __( 'Already Subscribed!', 'smile' ) : __( 'Already Subscribed!', 'smile' );
						}
			        }
			    }

			} else {
				if( isset( $_POST['only_conversion'] ) ? true : false ){
					// update conversions 
					$status = 'success';
					$ret = true;
					smile_update_conversions( $style_id );
				} else {
					$msg = ( isset( $_POST['msg_wrong_email']  )  && $_POST['msg_wrong_email'] !== '' ) ? $_POST['msg_wrong_email'] : __( 'Please enter correct email address.', 'smile' );
					$status = 'error';
					$ret = false;
				}
			}

			if( isset( $_POST['source'] ) ) {
        		return $ret;
        	} else {
        		print_r(json_encode(array(
					'action' => ( isset( $_POST['message'] ) ) ? 'message' : 'redirect',
					'email_status' => $email_status,
					'status' => $status,
					'message' => $msg,
					'detailed_msg' => $detailed_msg,
					'url' => ( isset( $_POST['message'] ) ) ? 'none' : esc_url( $_POST['redirect'] ),
				)));

				exit();
        	}
		}

		/*
		 * Function Name: update_infusionsoft_authentication
		 * Function Description: Update infusionsoft values to ConvertPlug
		 */
		
		function update_infusionsoft_authentication() {

			if ( ! current_user_can( 'access_cp' ) ) {
				die(-1);
			}
			$post = $_POST;
			
			$data = array();
			$infusionsoft_api = $post['infusionsoft_api_key'];
			$infusionsoft_app = $post['infusionsoft_app'];

			if( $post['infusionsoft_api_key'] == "" ){
				print_r(json_encode(array(
					'status' => "error",
					'message' => __( "Please provide valid API Key for your " . $this->setting['name'] . " account.", "smile" )
				)));
				exit();
			}

			if( $post['infusionsoft_app'] == "" ){
				print_r(json_encode(array(
					'status' => "error",
					'message' => __( "Please provide valid App Name for your " . $this->setting['name'] . " account.", "smile" )
				)));
				exit();
			}
			ob_start();

			try {
				$myApp = new CP_iSDK;
				$res = $myApp->cfgCon( $infusionsoft_app, $infusionsoft_api, "on" );
				//$campaigns = $myApp->getWebFormMap();
				//echo '<pre>'; print_r($campaigns); echo '</pre>'; die;

				$need_request = true;
				$page         = 0;
				$campaigns    = array();

				while ( true == $need_request ) {
					$error_message = 'success';
					$lists_data = $myApp->dsQuery(
						'ContactGroup',
						1000,
						$page,
						array( 'Id' => '%' ),
						array( 'Id', 'GroupName' )
					);
					$campaigns     = array_merge( $campaigns, $lists_data );

					if ( 1000 > count( $lists_data ) ) {
						$need_request = false;
					} else {
						$page ++;
					}
				}

				if( count( $campaigns ) < 1 ) {
					print_r(json_encode(array(
	                    'status' => "error",
	                    'message' => __( "You have zero tags in your " . $this->setting['name'] . " account. You must have at least one tag before integration." , "smile" )
	                )));
	                exit();
				}

				if( count( $campaigns ) > 0 ) {
					$query = '';
				?>
				<label for="<?php echo $this->slug; ?>-list">Select Lists</label>
				<select id="<?php echo $this->slug; ?>-list" class="bsf-cnlist-select select2-<?php echo $this->slug; ?>-list" name="<?php echo $this->slug; ?>-list" multiple>
				<?php
					foreach ($campaigns as $key => $cm) {
						if( isset( $cm['GroupName'] ) ){						
							$query .= $cm['Id'].'|'.$cm['GroupName'].',';
							$infusionsoft_lists[$cm['Id']] = $cm['GroupName'];
					?>
					<option value="<?php echo $cm['Id']; ?>"><?php echo $cm['GroupName']; ?></option>
				<?php
						}
					}
				?>
				</select>
				<div class="bsf-cnlist-form-row <?php echo $this->slug; ?>-action_id">
					<label for="cp-list-name" ><?php _e( "Action ID", "smile" ); ?></label>
	            	<input type="text" autocomplete="off" id="<?php echo $this->slug; ?>_action_id" name="<?php echo $this->slug; ?>_action_id" value="" placeholder="(Optional)"/>
		        </div>
		        <div class="bsf-cnlist-form-row">
            		<div class="bsf-cnlist-mailer-help ">
            			<a target="_blank" href="http://evergreenbusinesssystem.com/webinarfiles/infusionsoft_integration_manual.pdf">Where is Action ID?</a>
            		</div>
            	</div>
				<input type="hidden" id="mailer-all-lists" value="<?php echo $query; ?>"/>
				<input type="hidden" id="mailer-list-action" value="update_<?php echo $this->slug; ?>_list"/>
				<input type="hidden" id="mailer-list-api" value="<?php echo $infusionsoft_api; ?>"/>
				<div class="bsf-cnlist-form-row">
					<div id="disconnect-<?php echo $this->slug; ?>" class="button button-secondary" data-mailerslug="<?php echo $this->setting['name']; ?>" data-mailer="<?php echo $this->slug; ?>">
						<span><?php _e( "Use different '" . $this->setting['name'] . "' account?", "smile" ); ?></span>
					</div>
					<span class="spinner" style="float: none;"></span>
				</div>
				<?php
				} else {
				?>
					<label for="<?php echo $this->slug; ?>-list"><?php echo __( "You need at least one list added in " . $this->setting['name'] . " before proceeding.", "smile" ); ?></label>
				<?php
				}
			} catch( CP_iSDKException $ex ) {
				if ( strpos( $ex, 'ERROR' ) !== FALSE ) {
					print_r(json_encode(array(
						'status' => "error",
						'message' => __( "Access denied: Invalid credentials (App Name and/or API key).", "smile" )
					)));
					exit();
				}      
			}
			
			$html = ob_get_clean();

			update_option( $this->slug.'_api_key', $infusionsoft_api );
			update_option( $this->slug.'_app', $infusionsoft_app );
			update_option( $this->slug.'_lists', $infusionsoft_lists );

			print_r(json_encode(array(
				'status' => "success",
				'message' => $html
			)));

			exit();
		}


		/*
		 * Function Name: disconnect_infusionsoft
		 * Function Description: Disconnect current Infusionsoft from wp instance
		 */
		
		function disconnect_infusionsoft() {
			delete_option( 'infusionsoft_api_key' );
			delete_option( 'infusionsoft_app' );
			
			$smile_lists = get_option('smile_lists');			
			if( !empty( $smile_lists ) ){ 
				foreach( $smile_lists as $key => $list ) {
					$provider = $list['list-provider'];
					if( strtolower( $provider ) == strtolower( $this->slug ) ){
						$smile_lists[$key]['list-provider'] = "Convert Plug";
						$contacts_option = "cp_" . $this->slug . "_" . preg_replace( '#[ _]+#', '_', strtolower( $list['list-name'] ) );
                        $contact_list = get_option( $contacts_option );
                        $deleted = delete_option( $contacts_option );
                        $status = update_option( "cp_connects_" . preg_replace( '#[ _]+#', '_', strtolower( $list['list-name'] ) ), $contact_list );
					}
				}
				update_option( 'smile_lists', $smile_lists );
			}
			
			print_r(json_encode(array(
                'message' => "disconnected",
			)));
			die();
		}

		/*
		 * Function Name: get_infusionsoft_lists
		 * Function Description: Get Infusionsoft Mailer Campaign list
		 */

		function get_infusionsoft_lists( $infusionsoft_api = '', $infusionsoft_app = '' ) {
			if( $infusionsoft_api != '' && $infusionsoft_app != '' ) {
				try {
					$myApp = new CP_iSDK;
					$res = $myApp->cfgCon( $infusionsoft_app, $infusionsoft_api, "on" );
					//$campaigns = $myApp->getWebFormMap();

					$need_request = true;
					$page         = 0;
					$campaigns    = array();

					while ( true == $need_request ) {
						$error_message = 'success';
						$lists_data = $myApp->dsQuery(
							'ContactGroup',
							1000,
							$page,
							array( 'Id' => '%' ),
							array( 'Id', 'GroupName' )
						);
						$campaigns     = array_merge( $campaigns, $lists_data );

						if ( 1000 > count( $lists_data ) ) {
							$need_request = false;
						} else {
							$page ++;
						}
					}

					if( count( $campaigns ) > 0 ) {
						$lists = array();
						foreach( $campaigns as $offset => $cm ) {
							if( isset( $cm['GroupName'] ) ){
								$lists[$cm['Id']] = $cm['GroupName'];
							}
						}
						return $lists;
					}
				} catch( CP_iSDKException $ex ) {
					return array();
				}	
			}
			return array();
		}
	}
	new Smile_Mailer_Infusionsoft;
}